/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using Borland.Eco.UmlRt;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;
using Borland.Eco.Handles;
using System.Globalization;

namespace Borland.Eco.Web
{
	/// <summary>
	/// Summary description for ParameterBinding.
	/// </summary>
	public class ParameterBinding
	{
		private Control ctrl;
		private OclVariable var;

		public ParameterBinding(Control ctrl, OclVariable var): base()
		{
			this.ctrl = ctrl;
			this.var = var;
		}

		public void Apply()
		{
			IClassifier stringType = var.ElementHandle.Element.UmlType.EcoClassifier.TypeSystem.GetClassifierByType(typeof(System.String));
			if (stringType.EcoClassifier.ConformsTo(var.ElementHandle.Element.UmlType))
				var.ElementHandle.Element.AsObject = stringType.EcoClassifier.ConvertAsObject(((TextBox) ctrl).Text, var.ElementHandle.Element.UmlType);
			else
			{
				Type targetType = var.ElementHandle.Element.UmlType.ObjectType;
				if (targetType.IsPrimitive)
				{
					// TODO: handle other datatypes. i.e. use Parse, etc...
					TextBox tbx = ctrl as TextBox;
					if (tbx != null)
						var.ElementHandle.Element.AsObject = Convert.ChangeType(tbx.Text, targetType, CultureInfo.InvariantCulture);
					else {
						CheckBox cbx = ctrl as CheckBox;
						if (cbx != null)
							var.ElementHandle.Element.AsObject = Convert.ChangeType(cbx.Checked, targetType, CultureInfo.InvariantCulture);
					}
				}
				else
					throw new InvalidOperationException(
						WebStringRes.sUnableToConvert(targetType.ToString() ,var.ElementHandle.Element.UmlType.ObjectType));
			}
		}
	}
}
